/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NbtIngredient
extends Ingredient {
    private final ItemStack stack;
    private final ItemStack[] matchingStacks;
    public final boolean exactMatch;

    public NbtIngredient(ItemStack stack) {
        this(stack, false);
    }

    public NbtIngredient(ItemStack stack, boolean exactMatch) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack.func_77946_l();
        this.exactMatch = exactMatch;
        this.matchingStacks = new ItemStack[]{stack.func_77946_l()};
    }

    public boolean test(@Nullable ItemStack input) {
        CompoundNBT inputNbt;
        if (input == null || this.stack.func_190926_b() || input.func_77973_b() != this.stack.func_77973_b()) {
            return false;
        }
        if (input.func_77984_f() != this.stack.func_77984_f() || this.stack.func_77984_f() && input.func_77952_i() != this.stack.func_77952_i()) {
            return false;
        }
        CompoundNBT nbt = this.stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        if ((inputNbt = input.func_77978_p()) == null) {
            inputNbt = new CompoundNBT();
        }
        if (this.exactMatch) {
            return inputNbt.equals((Object)nbt);
        }
        CompoundNBT merged = inputNbt.func_74737_b();
        merged = merged.func_197643_a(nbt);
        return merged.equals((Object)inputNbt);
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        return this.matchingStacks;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        if (this.stack.func_77942_o()) {
            json.addProperty("nbt", this.stack.func_77978_p().toString());
        }
        json.addProperty("exactMatch", Boolean.valueOf(this.exactMatch));
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NbtIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public NbtIngredient parse(PacketBuffer buffer) {
            return new NbtIngredient(buffer.func_150791_c(), buffer.readBoolean());
        }

        @Nonnull
        public NbtIngredient parse(@Nonnull JsonObject json) {
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            boolean exactMatch = false;
            if (json.has("exactMatch")) {
                exactMatch = json.get("exactMatch").getAsBoolean();
            }
            return new NbtIngredient(stack, exactMatch);
        }

        public void write(PacketBuffer buffer, NbtIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
            buffer.writeBoolean(ingredient.exactMatch);
        }
    }
}

